/*  Ermittle die Kapazitätsbelastung für eine gegebene Kombination aus Ressourcen-ID und Datum.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__day_kapa_belast__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__day_kapa_belast__get(
    _resource_id  int,      -- Die Ressourcen-ID für die die Kapazitätsbelastung ermittlet werden soll.
    _date         date      -- Der Tag für die die Kapazitätsbelastung ermittlet werden soll.
) RETURNS numeric AS $$

    SELECT sum( extract ( epoch FROM ( ti_date_end - ti_date_start ) )::numeric * ti_ta_kf )
      FROM scheduling.resource_timeline
      JOIN scheduling.resource r ON r.id = ti_resource_id AND r.context = 'ksvba' -- Prüfen, ob es die referenzierte Ressource gibt.
      JOIN ab2 ON a2_id = ti_a2_id                                                -- Prüfen, ob es den refferenzierten AG gibt.
     WHERE ti_type IN ( 'task', 'task.blocktime', 'task.buffer' )
       AND ti_a2_id IS NOT null
       AND ti_resource_id = _resource_id                                          -- Einschränkung auf gegebene Ressourcen-ID
       AND ti_date_start::date = _date                                            -- Einschränkung auf gegebenes Datum

  $$ LANGUAGE SQL VOLATILE;